/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Scheduler;
import dev.compactmods.crafting.lib.reactivex.rxjava3.disposables.Disposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.flowables.ConnectableFlowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Consumer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.DisposableHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class FlowableRefCount<T>
extends Flowable<T> {
    final ConnectableFlowable<T> source;
    final int n;
    final long timeout;
    final TimeUnit unit;
    final Scheduler scheduler;
    RefConnection connection;

    public FlowableRefCount(ConnectableFlowable<T> source) {
        this(source, 1, 0L, TimeUnit.NANOSECONDS, null);
    }

    public FlowableRefCount(ConnectableFlowable<T> source, int n, long timeout, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.n = n;
        this.timeout = timeout;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        RefConnection conn;
        boolean connect = false;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c;
            conn = this.connection;
            if (conn == null) {
                this.connection = conn = new RefConnection(this);
            }
            if ((c = conn.subscriberCount) == 0L && conn.timer != null) {
                conn.timer.dispose();
            }
            conn.subscriberCount = c + 1L;
            if (!conn.connected && c + 1L == (long)this.n) {
                connect = true;
                conn.connected = true;
            }
        }
        this.source.subscribe((FlowableSubscriber<? super T>)new RefCountSubscriber<T>(s, this, conn));
        if (connect) {
            this.source.connect(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel(RefConnection rc) {
        SequentialDisposable sd;
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            long c;
            if (this.connection == null || this.connection != rc) {
                return;
            }
            rc.subscriberCount = c = rc.subscriberCount - 1L;
            if (c != 0L || !rc.connected) {
                return;
            }
            if (this.timeout == 0L) {
                this.timeout(rc);
                return;
            }
            sd = new SequentialDisposable();
            rc.timer = sd;
        }
        sd.replace(this.scheduler.scheduleDirect(rc, this.timeout, this.unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminated(RefConnection rc) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (this.connection == rc) {
                if (rc.timer != null) {
                    rc.timer.dispose();
                    rc.timer = null;
                }
                if (--rc.subscriberCount == 0L) {
                    this.connection = null;
                    this.source.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout(RefConnection rc) {
        FlowableRefCount flowableRefCount = this;
        synchronized (flowableRefCount) {
            if (rc.subscriberCount == 0L && rc == this.connection) {
                this.connection = null;
                Disposable connectionObject = (Disposable)rc.get();
                DisposableHelper.dispose(rc);
                if (connectionObject == null) {
                    rc.disconnectedEarly = true;
                } else {
                    this.source.reset();
                }
            }
        }
    }

    static final class RefCountSubscriber<T>
    extends AtomicBoolean
    implements FlowableSubscriber<T>,
    Subscription {
        private static final long serialVersionUID = -7419642935409022375L;
        final Subscriber<? super T> downstream;
        final FlowableRefCount<T> parent;
        final RefConnection connection;
        Subscription upstream;

        RefCountSubscriber(Subscriber<? super T> actual, FlowableRefCount<T> parent, RefConnection connection) {
            this.downstream = actual;
            this.parent = parent;
            this.connection = connection;
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onError(t);
            } else {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public void onComplete() {
            if (this.compareAndSet(false, true)) {
                this.parent.terminated(this.connection);
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            if (this.compareAndSet(false, true)) {
                this.parent.cancel(this.connection);
            }
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }
    }

    static final class RefConnection
    extends AtomicReference<Disposable>
    implements Runnable,
    Consumer<Disposable> {
        private static final long serialVersionUID = -4552101107598366241L;
        final FlowableRefCount<?> parent;
        Disposable timer;
        long subscriberCount;
        boolean connected;
        boolean disconnectedEarly;

        RefConnection(FlowableRefCount<?> parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            this.parent.timeout(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Disposable t) {
            DisposableHelper.replace(this, t);
            FlowableRefCount<?> flowableRefCount = this.parent;
            synchronized (flowableRefCount) {
                if (this.disconnectedEarly) {
                    this.parent.source.reset();
                }
            }
        }
    }
}

